using UnityEngine;
using System.Collections;

public class Programmez : MonoBehaviour {

	public float	rotationSpeed = 10.0f;
	public Color	objectColor = Color.red ;

	private string	_fps = "";
	private float	_counter = 0;

	private bool	_displayFPS = false ;

	void Start () {
		this.GetComponent<Renderer>().material.color = this.objectColor;
	}

	void Update () {
		this.transform.RotateAround(Vector3.up, this.rotationSpeed * Time.deltaTime);
	
		this._counter -= Time.deltaTime ;

		if (this._counter <= 0) {
			this._counter = 1;
			this._fps = Mathf.RoundToInt(1 / Time.deltaTime) + " FPS";
		}

		if (Input.GetKeyDown(KeyCode.Space))
			this._displayFPS = !this._displayFPS ;
	} 
	
	void OnGUI () {
		if (GUI.Button(new Rect(20, 60, 150, 30), "Display FPS"))
			this._displayFPS = !this._displayFPS ;

		if (this._displayFPS)
			GUI.Label(new Rect(20, 20, 200, 30), this._fps);
	}
}
